/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitEnrollMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitEnrollDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitEnrollFileDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitEnrollReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitEnroll;
import com.yqbsoft.laser.service.recruit.service.RecRecruitEnrollFileService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitEnrollService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitEnrollServiceImpl
extends BaseServiceImpl
implements RecRecruitEnrollService {
    private static final String SYS_CODE = "rec.RecRecruitEnrollServiceImpl";
    private RecRecruitEnrollMapper recRecruitEnrollMapper;
    private RecRecruitEnrollFileService recRecruitEnrollFileService;

    public void setRecRecruitEnrollMapper(RecRecruitEnrollMapper recRecruitEnrollMapper) {
        this.recRecruitEnrollMapper = recRecruitEnrollMapper;
    }

    public void setRecRecruitEnrollFileService(RecRecruitEnrollFileService recRecruitEnrollFileService) {
        this.recRecruitEnrollFileService = recRecruitEnrollFileService;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitEnrollMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecruitEnroll(RecRecruitEnrollDomain recRecruitEnrollDomain) {
        if (null == recRecruitEnrollDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getMemberCcode())) {
            msg = msg + "MemberCcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getMemberCname())) {
            msg = msg + "MemberCname\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getGoodsReceiptArrdess())) {
            msg = msg + "GoodsReceiptArrdess\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getGoodsReceiptEmail())) {
            msg = msg + "GoodsReceiptEmail\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getGoodsReceiptMem())) {
            msg = msg + "GoodsReceiptMem\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitEnrollDomain.getAreaName())) {
            msg = msg + "AreaName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecruitEnrollDefault(RecRecruitEnroll recRecruitEnroll) {
        if (null == recRecruitEnroll) {
            return;
        }
        if (null == recRecruitEnroll.getDataState()) {
            recRecruitEnroll.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitEnroll.getGmtCreate()) {
            recRecruitEnroll.setGmtCreate(date);
        }
        recRecruitEnroll.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitEnroll.getRecruitEnrollCode())) {
            recRecruitEnroll.setRecruitEnrollCode(this.createUUIDString());
        }
    }

    private int getRecruitEnrollMaxCode() {
        int code = 0;
        try {
            return this.recRecruitEnrollMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.getRecruitEnrollMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecruitEnrollUpdataDefault(RecRecruitEnroll recRecruitEnroll) {
        if (null == recRecruitEnroll) {
            return;
        }
        recRecruitEnroll.setGmtModified(this.getSysDate());
    }

    private void saveRecruitEnrollModel(RecRecruitEnroll recRecruitEnroll) throws ApiException {
        if (null == recRecruitEnroll) {
            return;
        }
        try {
            this.recRecruitEnrollMapper.insert(recRecruitEnroll);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.saveRecruitEnrollModel.ex", (Throwable)e);
        }
    }

    private void saveRecruitEnrollBatchModel(List<RecRecruitEnroll> recRecruitEnrollList) throws ApiException {
        if (null == recRecruitEnrollList || recRecruitEnrollList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitEnrollMapper.insertBatch(recRecruitEnrollList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.saveRecruitEnrollBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitEnroll getRecruitEnrollModelById(Integer recruitEnrollId) {
        if (null == recruitEnrollId) {
            return null;
        }
        try {
            return this.recRecruitEnrollMapper.selectByPrimaryKey(recruitEnrollId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.getRecruitEnrollModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitEnroll getRecruitEnrollModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitEnrollMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.getRecruitEnrollModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecruitEnrollModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.delRecruitEnrollModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.delRecruitEnrollModelByCode.num");
        }
    }

    private void deleteRecruitEnrollModel(Integer recruitEnrollId) throws ApiException {
        if (null == recruitEnrollId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollMapper.deleteByPrimaryKey(recruitEnrollId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.deleteRecruitEnrollModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.deleteRecruitEnrollModel.num");
        }
    }

    private void updateRecruitEnrollModel(RecRecruitEnroll recRecruitEnroll) throws ApiException {
        if (null == recRecruitEnroll) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollMapper.updateByPrimaryKey(recRecruitEnroll);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateRecruitEnrollModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateRecruitEnrollModel.num");
        }
    }

    private void updateStateRecruitEnrollModel(Integer recruitEnrollId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitEnrollId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitEnrollId", recruitEnrollId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateStateRecruitEnrollModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateStateRecruitEnrollModel.null");
        }
    }

    private void updateStateRecruitEnrollModelByCode(String tenantCode, String recruitEnrollCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitEnrollCode", recruitEnrollCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateStateRecruitEnrollModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateStateRecruitEnrollModelByCode.null");
        }
    }

    private RecRecruitEnroll makeRecruitEnroll(RecRecruitEnrollDomain recRecruitEnrollDomain, RecRecruitEnroll recRecruitEnroll) {
        if (null == recRecruitEnrollDomain) {
            return null;
        }
        if (null == recRecruitEnroll) {
            recRecruitEnroll = new RecRecruitEnroll();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitEnroll, (Object)recRecruitEnrollDomain);
            return recRecruitEnroll;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.makeRecruitEnroll", (Throwable)e);
            return null;
        }
    }

    private RecRecruitEnrollReDomain makeRecRecruitEnrollReDomain(RecRecruitEnroll recRecruitEnroll) {
        if (null == recRecruitEnroll) {
            return null;
        }
        RecRecruitEnrollReDomain recRecruitEnrollReDomain = new RecRecruitEnrollReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitEnrollReDomain, (Object)recRecruitEnroll);
            return recRecruitEnrollReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.makeRecRecruitEnrollReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitEnroll> queryRecruitEnrollModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitEnrollMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.queryRecruitEnrollModel", (Throwable)e);
            return null;
        }
    }

    private int countRecruitEnroll(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitEnrollMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollServiceImpl.countRecruitEnroll", (Throwable)e);
        }
        return i;
    }

    private RecRecruitEnroll createRecRecruitEnroll(RecRecruitEnrollDomain recRecruitEnrollDomain) {
        String msg = this.checkRecruitEnroll(recRecruitEnrollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.saveRecruitEnroll.checkRecruitEnroll", msg);
        }
        RecRecruitEnroll recRecruitEnroll = this.makeRecruitEnroll(recRecruitEnrollDomain, null);
        this.setRecruitEnrollDefault(recRecruitEnroll);
        return recRecruitEnroll;
    }

    @Override
    public String saveRecruitEnroll(RecRecruitEnrollDomain recRecruitEnrollDomain) throws ApiException {
        RecRecruitEnroll recRecruitEnroll = this.createRecRecruitEnroll(recRecruitEnrollDomain);
        this.saveRecruitEnrollModel(recRecruitEnroll);
        if (ListUtil.isNotEmpty(recRecruitEnrollDomain.getRecRecruitEnrollFileDomainList())) {
            for (RecRecruitEnrollFileDomain recRecruitEnrollFileDomain : recRecruitEnrollDomain.getRecRecruitEnrollFileDomainList()) {
                recRecruitEnrollFileDomain.setRecruitEnrollCode(recRecruitEnroll.getRecruitEnrollCode());
                recRecruitEnrollFileDomain.setTenantCode(recRecruitEnroll.getTenantCode());
                recRecruitEnrollFileDomain.setRecruitCode(recRecruitEnroll.getRecruitCode());
                recRecruitEnrollFileDomain.setRecruitName(recRecruitEnroll.getRecruitName());
                recRecruitEnrollFileDomain.setRecruitType(recRecruitEnroll.getRecruitType());
                this.recRecruitEnrollFileService.saveRecruitEnrollFile(recRecruitEnrollFileDomain);
            }
        }
        return recRecruitEnroll.getRecruitEnrollCode();
    }

    @Override
    public String saveRecruitEnrollBatch(List<RecRecruitEnrollDomain> recRecruitEnrollDomainList) throws ApiException {
        if (null == recRecruitEnrollDomainList || recRecruitEnrollDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitEnroll> recRecruitEnrollList = new ArrayList<RecRecruitEnroll>();
        String code = "";
        for (RecRecruitEnrollDomain recRecruitEnrollDomain : recRecruitEnrollDomainList) {
            RecRecruitEnroll recRecruitEnroll = this.createRecRecruitEnroll(recRecruitEnrollDomain);
            code = recRecruitEnroll.getRecruitEnrollCode();
            recRecruitEnrollList.add(recRecruitEnroll);
        }
        this.saveRecruitEnrollBatchModel(recRecruitEnrollList);
        return code;
    }

    @Override
    public void updateRecruitEnrollState(Integer recruitEnrollId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitEnrollId) {
            return;
        }
        this.updateStateRecruitEnrollModel(recruitEnrollId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitEnrollStateByCode(String tenantCode, String recruitEnrollCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecruitEnrollModelByCode(tenantCode, recruitEnrollCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitEnroll(RecRecruitEnrollDomain recRecruitEnrollDomain) throws ApiException {
        String msg = this.checkRecruitEnroll(recRecruitEnrollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateRecruitEnroll.checkRecruitEnroll", msg);
        }
        RecRecruitEnroll oldRecRecruitEnroll = this.getRecruitEnrollModelById(recRecruitEnrollDomain.getRecruitEnrollId());
        if (null == oldRecRecruitEnroll) {
            throw new ApiException("rec.RecRecruitEnrollServiceImpl.updateRecruitEnroll.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitEnroll recRecruitEnroll = this.makeRecruitEnroll(recRecruitEnrollDomain, oldRecRecruitEnroll);
        this.setRecruitEnrollUpdataDefault(recRecruitEnroll);
        this.updateRecruitEnrollModel(recRecruitEnroll);
    }

    @Override
    public RecRecruitEnroll getRecruitEnroll(Integer recruitEnrollId) {
        if (null == recruitEnrollId) {
            return null;
        }
        return this.getRecruitEnrollModelById(recruitEnrollId);
    }

    @Override
    public void deleteRecruitEnroll(Integer recruitEnrollId) throws ApiException {
        if (null == recruitEnrollId) {
            return;
        }
        this.deleteRecruitEnrollModel(recruitEnrollId);
    }

    @Override
    public QueryResult<RecRecruitEnroll> queryRecruitEnrollPage(Map<String, Object> map) {
        List<RecRecruitEnroll> recRecruitEnrollList = this.queryRecruitEnrollModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecruitEnroll(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitEnrollList);
        return queryResult;
    }

    @Override
    public RecRecruitEnroll getRecruitEnrollByCode(String tenantCode, String recruitEnrollCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitEnrollCode", recruitEnrollCode);
        return this.getRecruitEnrollModelByCode(map);
    }

    @Override
    public void deleteRecruitEnrollByCode(String tenantCode, String recruitEnrollCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitEnrollCode", recruitEnrollCode);
        this.delRecruitEnrollModelByCode(map);
    }
}

