/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.UmUserInfoMapper;
import com.yqbsoft.laser.service.recruit.domain.UmUserInfoDomain;
import com.yqbsoft.laser.service.recruit.domain.UmUserInfoReDomain;
import com.yqbsoft.laser.service.recruit.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.recruit.model.UmUserInfo;
import com.yqbsoft.laser.service.recruit.service.UmUserInfoService;
import com.yqbsoft.laser.service.recruit.service.UmUserinfoQuaService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmUserInfoServiceImpl
extends BaseServiceImpl
implements UmUserInfoService {
    private static final String SYS_CODE = "rec.UmUserInfoServiceImpl";
    private UmUserInfoMapper umUserInfoMapper;
    private UmUserinfoQuaService umUserinfoQuaService;

    public void setUmUserInfoMapper(UmUserInfoMapper umUserInfoMapper) {
        this.umUserInfoMapper = umUserInfoMapper;
    }

    public UmUserInfoMapper getUmUserInfoMapper() {
        return this.umUserInfoMapper;
    }

    public UmUserinfoQuaService getUmUserinfoQuaService() {
        return this.umUserinfoQuaService;
    }

    public void setUmUserinfoQuaService(UmUserinfoQuaService umUserinfoQuaService) {
        this.umUserinfoQuaService = umUserinfoQuaService;
    }

    private Date getSysDate() {
        try {
            return this.umUserInfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUmUserInfo(UmUserInfoDomain umUserInfoDomain) {
        this.logger.info("umUserInfoDomain3------------------------------------------------" + umUserInfoDomain);
        System.out.println("umUserInfoDomain4------------------------------------------------" + umUserInfoDomain);
        if (null == umUserInfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUserInfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUmUserInfoDefault(UmUserInfo umUserInfo) {
        if (null == umUserInfo) {
            return;
        }
        if (null == umUserInfo.getDataState()) {
            umUserInfo.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umUserInfo.getGmtCreate()) {
            umUserInfo.setGmtCreate(date);
        }
        umUserInfo.setGmtModified(date);
        if (StringUtils.isBlank((String)umUserInfo.getUserinfoCode())) {
            umUserInfo.setUserinfoCode(this.getNo(null, "UmUserInfo", "umUserInfo", umUserInfo.getTenantCode()));
        }
    }

    private int getUmUserInfoMaxCode() {
        int code = 0;
        try {
            return this.umUserInfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.getUmUserInfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUmUserInfoUpdataDefault(UmUserInfo umUserInfo) {
        if (null == umUserInfo) {
            return;
        }
        umUserInfo.setGmtModified(this.getSysDate());
    }

    private void saveUmUserInfoModel(UmUserInfo umUserInfo) throws ApiException {
        if (null == umUserInfo) {
            return;
        }
        try {
            int i = this.umUserInfoMapper.insert(umUserInfo);
            this.logger.info("umUserInfoMapper.insert-----------------------------------" + i);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException("rec.UmUserInfoServiceImpl.saveUmUserInfoModel.ex", (Throwable)e);
        }
    }

    private void saveUmUserInfoBatchModel(List<UmUserInfo> umUserInfoList) throws ApiException {
        if (null == umUserInfoList || umUserInfoList.isEmpty()) {
            return;
        }
        try {
            this.umUserInfoMapper.insertBatch(umUserInfoList);
        }
        catch (Exception e) {
            throw new ApiException("rec.UmUserInfoServiceImpl.saveUmUserInfoBatchModel.ex", (Throwable)e);
        }
    }

    private UmUserInfo getUmUserInfoModelById(Integer umUserInfoId) {
        if (null == umUserInfoId) {
            return null;
        }
        try {
            return this.umUserInfoMapper.selectByPrimaryKey(umUserInfoId);
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.getUmUserInfoModelById", (Throwable)e);
            return null;
        }
    }

    private UmUserInfo getUmUserInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umUserInfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.getUmUserInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUmUserInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserInfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.UmUserInfoServiceImpl.delUmUserInfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.UmUserInfoServiceImpl.delUmUserInfoModelByCode.num");
        }
    }

    private void deleteUmUserInfoModel(Integer umUserInfoId) throws ApiException {
        if (null == umUserInfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserInfoMapper.deleteByPrimaryKey(umUserInfoId);
        }
        catch (Exception e) {
            throw new ApiException("rec.UmUserInfoServiceImpl.deleteUmUserInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.UmUserInfoServiceImpl.deleteUmUserInfoModel.num");
        }
    }

    private void updateUmUserInfoModel(UmUserInfo umUserInfo) throws ApiException {
        if (null == umUserInfo) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserInfoMapper.updateByPrimaryKey(umUserInfo);
        }
        catch (Exception e) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateUmUserInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateUmUserInfoModel.num");
        }
    }

    private void updateStateUmUserInfoModel(Integer umUserInfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == umUserInfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("umUserInfoId", umUserInfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUserInfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateStateUmUserInfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateStateUmUserInfoModel.null");
        }
    }

    private void updateStateUmUserInfoModelByCode(String tenantCode, String umUserInfoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)umUserInfoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("umUserInfoCode", umUserInfoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUserInfoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateStateUmUserInfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateStateUmUserInfoModelByCode.null");
        }
    }

    private UmUserInfo makeUmUserInfo(UmUserInfoDomain umUserInfoDomain, UmUserInfo umUserInfo) {
        if (null == umUserInfoDomain) {
            return null;
        }
        if (null == umUserInfo) {
            umUserInfo = new UmUserInfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserInfo, (Object)umUserInfoDomain);
            return umUserInfo;
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.makeUmUserInfo", (Throwable)e);
            return null;
        }
    }

    private UmUserInfoReDomain makeUmUserInfoReDomain(UmUserInfo umUserInfo) {
        if (null == umUserInfo) {
            return null;
        }
        UmUserInfoReDomain umUserInfoReDomain = new UmUserInfoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umUserInfoReDomain, (Object)umUserInfo);
            return umUserInfoReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.makeUmUserInfoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmUserInfo> queryUmUserInfoModelPage(Map<String, Object> parammap) {
        try {
            this.logger.error("queryUmUserInfoModelPage-------------------service88------------------------" + parammap);
            System.out.println("queryUmUserInfoModelPage-------------------service89------------------------" + parammap);
            return this.umUserInfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.queryUmUserInfoModel", (Throwable)e);
            return null;
        }
    }

    private int countUmUserInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserInfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.UmUserInfoServiceImpl.countUmUserInfo", (Throwable)e);
        }
        return i;
    }

    private UmUserInfo createUmUserInfo(UmUserInfoDomain umUserInfoDomain) {
        String msg = this.checkUmUserInfo(umUserInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.UmUserInfoServiceImpl.saveUmUserInfo.checkUmUserInfo", msg);
        }
        UmUserInfo umUserInfo = this.makeUmUserInfo(umUserInfoDomain, null);
        this.setUmUserInfoDefault(umUserInfo);
        return umUserInfo;
    }

    @Override
    public String saveUmUserInfo(UmUserInfoDomain umUserInfoDomain) throws ApiException {
        UmUserInfo umUserInfo = this.createUmUserInfo(umUserInfoDomain);
        this.saveUmUserInfoModel(umUserInfo);
        List<UmUserinfoQuaDomain> umUserinfoQuaDomainList = umUserInfoDomain.getUmUserinfoQuaDomainList();
        ArrayList<UmUserinfoQuaDomain> umUserinfoQuaDomainListParam = new ArrayList<UmUserinfoQuaDomain>();
        if (null != umUserinfoQuaDomainList && umUserinfoQuaDomainList.size() > 0) {
            for (UmUserinfoQuaDomain umUserinfoQuaDomain : umUserinfoQuaDomainList) {
                umUserinfoQuaDomain.setTenantCode(umUserInfo.getTenantCode());
                umUserinfoQuaDomain.setUserinfoCode(umUserInfo.getUserinfoCode());
                umUserinfoQuaDomainListParam.add(umUserinfoQuaDomain);
            }
            this.umUserinfoQuaService.saveUmUserinfoQuaBatch(umUserinfoQuaDomainListParam);
        }
        return umUserInfo.getUserinfoCode();
    }

    @Override
    public String saveUmUserInfoBatch(List<UmUserInfoDomain> umUserInfoDomainList) throws ApiException {
        if (null == umUserInfoDomainList || umUserInfoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmUserInfo> umUserInfoList = new ArrayList<UmUserInfo>();
        String code = "";
        for (UmUserInfoDomain umUserInfoDomain : umUserInfoDomainList) {
            UmUserInfo umUserInfo = this.createUmUserInfo(umUserInfoDomain);
            code = umUserInfo.getUserinfoCode();
            umUserInfoList.add(umUserInfo);
        }
        this.saveUmUserInfoBatchModel(umUserInfoList);
        return code;
    }

    @Override
    public void updateUmUserInfoState(Integer umUserInfoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == umUserInfoId) {
            return;
        }
        this.updateStateUmUserInfoModel(umUserInfoId, dataState, oldDataState, map);
    }

    @Override
    public void updateUmUserInfoStateByCode(String tenantCode, String umUserInfoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)umUserInfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUmUserInfoModelByCode(tenantCode, umUserInfoCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUmUserInfo(UmUserInfoDomain umUserInfoDomain) throws ApiException {
        String msg = this.checkUmUserInfo(umUserInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateUmUserInfo.checkUmUserInfo", msg);
        }
        UmUserInfo oldUmUserInfo = this.getUmUserInfoModelById(umUserInfoDomain.getUserinfoId());
        if (null == oldUmUserInfo) {
            throw new ApiException("rec.UmUserInfoServiceImpl.updateUmUserInfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserInfo umUserInfo = this.makeUmUserInfo(umUserInfoDomain, oldUmUserInfo);
        this.setUmUserInfoUpdataDefault(umUserInfo);
        this.updateUmUserInfoModel(umUserInfo);
    }

    @Override
    public UmUserInfo getUmUserInfo(Integer umUserInfoId) {
        if (null == umUserInfoId) {
            return null;
        }
        return this.getUmUserInfoModelById(umUserInfoId);
    }

    @Override
    public void deleteUmUserInfo(Integer umUserInfoId) throws ApiException {
        if (null == umUserInfoId) {
            return;
        }
        this.deleteUmUserInfoModel(umUserInfoId);
    }

    @Override
    public QueryResult<UmUserInfo> queryUmUserInfoPage(Map<String, Object> map) {
        List<UmUserInfo> umUserInfoList = this.queryUmUserInfoModelPage(map);
        this.logger.error("query-------------------service771------------------------" + umUserInfoList.size());
        System.out.println("query-------------------service772------------------------" + umUserInfoList.size());
        if (null != umUserInfoList && umUserInfoList.size() > 0) {
            for (int i = 0; i < umUserInfoList.size(); ++i) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("fuzzy", false);
                param.put("userinfoCode", umUserInfoList.get(i).getUserinfoCode());
                List umUserinfoQuaList = this.umUserinfoQuaService.queryUmUserinfoQuaPage(param).getList();
                umUserInfoList.get(i).setUmUserinfoQuaList(umUserinfoQuaList);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUmUserInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserInfoList);
        return queryResult;
    }

    @Override
    public UmUserInfo getUmUserInfoByCode(String tenantCode, String umUserInfoCode) throws ApiException {
        if (StringUtils.isBlank((String)umUserInfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("umUserInfoCode", umUserInfoCode);
        return this.getUmUserInfoModelByCode(map);
    }

    @Override
    public void deleteUmUserInfoByCode(String tenantCode, String umUserInfoCode) throws ApiException {
        if (StringUtils.isBlank((String)umUserInfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("umUserInfoCode", umUserInfoCode);
        this.delUmUserInfoModelByCode(map);
    }
}

