/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitServiceAreaMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitServiceAreaDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitServiceAreaReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitServiceArea;
import com.yqbsoft.laser.service.recruit.service.RecRecruitServiceAreaService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitServiceAreaServiceImpl
extends BaseServiceImpl
implements RecRecruitServiceAreaService {
    private static final String SYS_CODE = "rec.RecRecruitServiceAreaServiceImpl";
    private RecRecruitServiceAreaMapper recRecruitServiceAreaMapper;

    public void setRecRecruitServiceAreaMapper(RecRecruitServiceAreaMapper recRecruitServiceAreaMapper) {
        this.recRecruitServiceAreaMapper = recRecruitServiceAreaMapper;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitServiceAreaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecRecruitServiceArea(RecRecruitServiceAreaDomain recRecruitServiceAreaDomain) {
        if (null == recRecruitServiceAreaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitServiceAreaDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecRecruitServiceAreaDefault(RecRecruitServiceArea recRecruitServiceArea) {
        if (null == recRecruitServiceArea) {
            return;
        }
        if (null == recRecruitServiceArea.getDataState()) {
            recRecruitServiceArea.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitServiceArea.getGmtCreate()) {
            recRecruitServiceArea.setGmtCreate(date);
        }
        recRecruitServiceArea.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitServiceArea.getRecruitServiceAreaCode())) {
            recRecruitServiceArea.setRecruitServiceAreaCode(this.getNo(null, "RecRecruitServiceArea", "recRecruitServiceArea", recRecruitServiceArea.getTenantCode()));
        }
    }

    private int getRecRecruitServiceAreaMaxCode() {
        int code = 0;
        try {
            return this.recRecruitServiceAreaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.getRecRecruitServiceAreaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecRecruitServiceAreaUpdataDefault(RecRecruitServiceArea recRecruitServiceArea) {
        if (null == recRecruitServiceArea) {
            return;
        }
        recRecruitServiceArea.setGmtModified(this.getSysDate());
    }

    private void saveRecRecruitServiceAreaModel(RecRecruitServiceArea recRecruitServiceArea) throws ApiException {
        if (null == recRecruitServiceArea) {
            return;
        }
        try {
            this.recRecruitServiceAreaMapper.insert(recRecruitServiceArea);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.saveRecRecruitServiceAreaModel.ex", (Throwable)e);
        }
    }

    private void saveRecRecruitServiceAreaBatchModel(List<RecRecruitServiceArea> recRecruitServiceAreaList) throws ApiException {
        if (null == recRecruitServiceAreaList || recRecruitServiceAreaList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitServiceAreaMapper.insertBatch(recRecruitServiceAreaList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.saveRecRecruitServiceAreaBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitServiceArea getRecRecruitServiceAreaModelById(Integer recruitServiceAreaId) {
        if (null == recruitServiceAreaId) {
            return null;
        }
        try {
            return this.recRecruitServiceAreaMapper.selectByPrimaryKey(recruitServiceAreaId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.getRecRecruitServiceAreaModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitServiceArea getRecRecruitServiceAreaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitServiceAreaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.getRecRecruitServiceAreaModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecRecruitServiceAreaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitServiceAreaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.delRecRecruitServiceAreaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.delRecRecruitServiceAreaModelByCode.num");
        }
    }

    private void deleteRecRecruitServiceAreaModel(Integer recruitServiceAreaId) throws ApiException {
        if (null == recruitServiceAreaId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitServiceAreaMapper.deleteByPrimaryKey(recruitServiceAreaId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.deleteRecRecruitServiceAreaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.deleteRecRecruitServiceAreaModel.num");
        }
    }

    private void updateRecRecruitServiceAreaModel(RecRecruitServiceArea recRecruitServiceArea) throws ApiException {
        if (null == recRecruitServiceArea) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitServiceAreaMapper.updateByPrimaryKey(recRecruitServiceArea);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateRecRecruitServiceAreaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateRecRecruitServiceAreaModel.num");
        }
    }

    private void updateStateRecRecruitServiceAreaModel(Integer recruitServiceAreaId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitServiceAreaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitServiceAreaId", recruitServiceAreaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitServiceAreaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateStateRecRecruitServiceAreaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateStateRecRecruitServiceAreaModel.null");
        }
    }

    private void updateStateRecRecruitServiceAreaModelByCode(String tenantCode, String recruitServiceAreaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitServiceAreaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitServiceAreaCode", recruitServiceAreaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitServiceAreaMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateStateRecRecruitServiceAreaModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateStateRecRecruitServiceAreaModelByCode.null");
        }
    }

    private RecRecruitServiceArea makeRecRecruitServiceArea(RecRecruitServiceAreaDomain recRecruitServiceAreaDomain, RecRecruitServiceArea recRecruitServiceArea) {
        if (null == recRecruitServiceAreaDomain) {
            return null;
        }
        if (null == recRecruitServiceArea) {
            recRecruitServiceArea = new RecRecruitServiceArea();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitServiceArea, (Object)recRecruitServiceAreaDomain);
            return recRecruitServiceArea;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.makeRecRecruitServiceArea", (Throwable)e);
            return null;
        }
    }

    private RecRecruitServiceAreaReDomain makeRecRecruitServiceAreaReDomain(RecRecruitServiceArea recRecruitServiceArea) {
        if (null == recRecruitServiceArea) {
            return null;
        }
        RecRecruitServiceAreaReDomain recRecruitServiceAreaReDomain = new RecRecruitServiceAreaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitServiceAreaReDomain, (Object)recRecruitServiceArea);
            return recRecruitServiceAreaReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.makeRecRecruitServiceAreaReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitServiceArea> queryRecRecruitServiceAreaModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitServiceAreaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.queryRecRecruitServiceAreaModel", (Throwable)e);
            return null;
        }
    }

    private int countRecRecruitServiceArea(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitServiceAreaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceAreaServiceImpl.countRecRecruitServiceArea", (Throwable)e);
        }
        return i;
    }

    private RecRecruitServiceArea createRecRecruitServiceArea(RecRecruitServiceAreaDomain recRecruitServiceAreaDomain) {
        String msg = this.checkRecRecruitServiceArea(recRecruitServiceAreaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.saveRecRecruitServiceArea.checkRecRecruitServiceArea", msg);
        }
        RecRecruitServiceArea recRecruitServiceArea = this.makeRecRecruitServiceArea(recRecruitServiceAreaDomain, null);
        this.setRecRecruitServiceAreaDefault(recRecruitServiceArea);
        return recRecruitServiceArea;
    }

    @Override
    public String saveRecRecruitServiceArea(RecRecruitServiceAreaDomain recRecruitServiceAreaDomain) throws ApiException {
        RecRecruitServiceArea recRecruitServiceArea = this.createRecRecruitServiceArea(recRecruitServiceAreaDomain);
        this.saveRecRecruitServiceAreaModel(recRecruitServiceArea);
        return recRecruitServiceArea.getRecruitServiceAreaCode();
    }

    @Override
    public String saveRecRecruitServiceAreaBatch(List<RecRecruitServiceAreaDomain> recRecruitServiceAreaDomainList) throws ApiException {
        if (null == recRecruitServiceAreaDomainList || recRecruitServiceAreaDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitServiceArea> recRecruitServiceAreaList = new ArrayList<RecRecruitServiceArea>();
        String code = "";
        for (RecRecruitServiceAreaDomain recRecruitServiceAreaDomain : recRecruitServiceAreaDomainList) {
            RecRecruitServiceArea recRecruitServiceArea = this.createRecRecruitServiceArea(recRecruitServiceAreaDomain);
            code = recRecruitServiceArea.getRecruitServiceAreaCode();
            recRecruitServiceAreaList.add(recRecruitServiceArea);
        }
        this.saveRecRecruitServiceAreaBatchModel(recRecruitServiceAreaList);
        return code;
    }

    @Override
    public void updateRecRecruitServiceAreaState(Integer recruitServiceAreaId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitServiceAreaId) {
            return;
        }
        this.updateStateRecRecruitServiceAreaModel(recruitServiceAreaId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecRecruitServiceAreaStateByCode(String tenantCode, String recruitServiceAreaCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitServiceAreaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecRecruitServiceAreaModelByCode(tenantCode, recruitServiceAreaCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecRecruitServiceArea(RecRecruitServiceAreaDomain recRecruitServiceAreaDomain) throws ApiException {
        String msg = this.checkRecRecruitServiceArea(recRecruitServiceAreaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateRecRecruitServiceArea.checkRecRecruitServiceArea", msg);
        }
        RecRecruitServiceArea oldRecRecruitServiceArea = this.getRecRecruitServiceAreaModelById(recRecruitServiceAreaDomain.getRecruitServiceAreaId());
        if (null == oldRecRecruitServiceArea) {
            throw new ApiException("rec.RecRecruitServiceAreaServiceImpl.updateRecRecruitServiceArea.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitServiceArea recRecruitServiceArea = this.makeRecRecruitServiceArea(recRecruitServiceAreaDomain, oldRecRecruitServiceArea);
        this.setRecRecruitServiceAreaUpdataDefault(recRecruitServiceArea);
        this.updateRecRecruitServiceAreaModel(recRecruitServiceArea);
    }

    @Override
    public RecRecruitServiceArea getRecRecruitServiceArea(Integer recruitServiceAreaId) {
        if (null == recruitServiceAreaId) {
            return null;
        }
        return this.getRecRecruitServiceAreaModelById(recruitServiceAreaId);
    }

    @Override
    public void deleteRecRecruitServiceArea(Integer recruitServiceAreaId) throws ApiException {
        if (null == recruitServiceAreaId) {
            return;
        }
        this.deleteRecRecruitServiceAreaModel(recruitServiceAreaId);
    }

    @Override
    public QueryResult<RecRecruitServiceArea> queryRecRecruitServiceAreaPage(Map<String, Object> map) {
        List<RecRecruitServiceArea> recRecruitServiceAreaList = this.queryRecRecruitServiceAreaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecRecruitServiceArea(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitServiceAreaList);
        return queryResult;
    }

    @Override
    public RecRecruitServiceArea getRecRecruitServiceAreaByCode(String tenantCode, String recruitServiceAreaCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitServiceAreaCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitServiceAreaCode", recruitServiceAreaCode);
        return this.getRecRecruitServiceAreaModelByCode(map);
    }

    @Override
    public void deleteRecRecruitServiceAreaByCode(String tenantCode, String recruitServiceAreaCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitServiceAreaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitServiceAreaCode", recruitServiceAreaCode);
        this.delRecRecruitServiceAreaModelByCode(map);
    }
}

