/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsMessageMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsMessageDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsMessageReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsMessage;
import com.yqbsoft.laser.service.resources.service.RsGoodsMessageService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsMessageServiceImpl
extends BaseServiceImpl
implements RsGoodsMessageService {
    private static final String SYS_CODE = "rs.RsGoodsMessageServiceImpl";
    private RsGoodsMessageMapper rsGoodsMessageMapper;

    public void setRsGoodsMessageMapper(RsGoodsMessageMapper rsGoodsMessageMapper) {
        this.rsGoodsMessageMapper = rsGoodsMessageMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsMessageMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsMessage(RsGoodsMessageDomain rsGoodsMessageDomain) {
        if (null == rsGoodsMessageDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsMessageDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsMessageDefault(RsGoodsMessage rsGoodsMessage) {
        if (null == rsGoodsMessage) {
            return;
        }
        if (null == rsGoodsMessage.getDataState()) {
            rsGoodsMessage.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsGoodsMessage.getGmtCreate()) {
            rsGoodsMessage.setGmtCreate(date);
        }
        rsGoodsMessage.setGmtModified(date);
        if (StringUtils.isBlank((String)rsGoodsMessage.getGoodsMessageCode())) {
            rsGoodsMessage.setGoodsMessageCode(this.getNo(null, "RsGoodsMessage", "rsGoodsMessage", rsGoodsMessage.getTenantCode()));
        }
    }

    private int getGoodsMessageMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsMessageMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.getGoodsMessageMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsMessageUpdataDefault(RsGoodsMessage rsGoodsMessage) {
        if (null == rsGoodsMessage) {
            return;
        }
        rsGoodsMessage.setGmtModified(this.getSysDate());
    }

    private void saveGoodsMessageModel(RsGoodsMessage rsGoodsMessage) throws ApiException {
        if (null == rsGoodsMessage) {
            return;
        }
        try {
            this.rsGoodsMessageMapper.insert(rsGoodsMessage);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.saveGoodsMessageModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsMessageBatchModel(List<RsGoodsMessage> rsGoodsMessageList) throws ApiException {
        if (null == rsGoodsMessageList || rsGoodsMessageList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsMessageMapper.insertBatch(rsGoodsMessageList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.saveGoodsMessageBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsMessage getGoodsMessageModelById(Integer goodsMessageId) {
        if (null == goodsMessageId) {
            return null;
        }
        try {
            return this.rsGoodsMessageMapper.selectByPrimaryKey(goodsMessageId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.getGoodsMessageModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsMessage getGoodsMessageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsMessageMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.getGoodsMessageModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsMessageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsMessageMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.delGoodsMessageModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.delGoodsMessageModelByCode.num");
        }
    }

    private void deleteGoodsMessageModel(Integer goodsMessageId) throws ApiException {
        if (null == goodsMessageId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsMessageMapper.deleteByPrimaryKey(goodsMessageId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.deleteGoodsMessageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.deleteGoodsMessageModel.num");
        }
    }

    private void updateGoodsMessageModel(RsGoodsMessage rsGoodsMessage) throws ApiException {
        if (null == rsGoodsMessage) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsMessageMapper.updateByPrimaryKey(rsGoodsMessage);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateGoodsMessageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateGoodsMessageModel.num");
        }
    }

    private void updateStateGoodsMessageModel(Integer goodsMessageId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsMessageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsMessageId", goodsMessageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsMessageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateStateGoodsMessageModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateStateGoodsMessageModel.null");
        }
    }

    private void updateStateGoodsMessageModelByCode(String tenantCode, String goodsMessageCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsMessageCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsMessageCode", goodsMessageCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsMessageMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateStateGoodsMessageModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateStateGoodsMessageModelByCode.null");
        }
    }

    private RsGoodsMessage makeGoodsMessage(RsGoodsMessageDomain rsGoodsMessageDomain, RsGoodsMessage rsGoodsMessage) {
        if (null == rsGoodsMessageDomain) {
            return null;
        }
        if (null == rsGoodsMessage) {
            rsGoodsMessage = new RsGoodsMessage();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsMessage, (Object)rsGoodsMessageDomain);
            return rsGoodsMessage;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.makeGoodsMessage", (Throwable)e);
            return null;
        }
    }

    private RsGoodsMessageReDomain makeRsGoodsMessageReDomain(RsGoodsMessage rsGoodsMessage) {
        if (null == rsGoodsMessage) {
            return null;
        }
        RsGoodsMessageReDomain rsGoodsMessageReDomain = new RsGoodsMessageReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsMessageReDomain, (Object)rsGoodsMessage);
            return rsGoodsMessageReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.makeRsGoodsMessageReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsMessage> queryGoodsMessageModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsMessageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.queryGoodsMessageModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsMessage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsMessageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsMessageServiceImpl.countGoodsMessage", (Throwable)e);
        }
        return i;
    }

    private RsGoodsMessage createRsGoodsMessage(RsGoodsMessageDomain rsGoodsMessageDomain) {
        String msg = this.checkGoodsMessage(rsGoodsMessageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.saveGoodsMessage.checkGoodsMessage", msg);
        }
        RsGoodsMessage rsGoodsMessage = this.makeGoodsMessage(rsGoodsMessageDomain, null);
        this.setGoodsMessageDefault(rsGoodsMessage);
        return rsGoodsMessage;
    }

    @Override
    public String saveGoodsMessage(RsGoodsMessageDomain rsGoodsMessageDomain) throws ApiException {
        RsGoodsMessage rsGoodsMessage = this.createRsGoodsMessage(rsGoodsMessageDomain);
        this.saveGoodsMessageModel(rsGoodsMessage);
        return rsGoodsMessage.getGoodsMessageCode();
    }

    @Override
    public String saveGoodsMessageBatch(List<RsGoodsMessageDomain> rsGoodsMessageDomainList) throws ApiException {
        if (null == rsGoodsMessageDomainList || rsGoodsMessageDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsMessage> rsGoodsMessageList = new ArrayList<RsGoodsMessage>();
        String code = "";
        for (RsGoodsMessageDomain rsGoodsMessageDomain : rsGoodsMessageDomainList) {
            RsGoodsMessage rsGoodsMessage = this.createRsGoodsMessage(rsGoodsMessageDomain);
            code = rsGoodsMessage.getGoodsMessageCode();
            rsGoodsMessageList.add(rsGoodsMessage);
        }
        this.saveGoodsMessageBatchModel(rsGoodsMessageList);
        return code;
    }

    @Override
    public void updateGoodsMessageState(Integer goodsMessageId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsMessageId) {
            return;
        }
        this.updateStateGoodsMessageModel(goodsMessageId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsMessageStateByCode(String tenantCode, String goodsMessageCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsMessageCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsMessageModelByCode(tenantCode, goodsMessageCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsMessage(RsGoodsMessageDomain rsGoodsMessageDomain) throws ApiException {
        String msg = this.checkGoodsMessage(rsGoodsMessageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateGoodsMessage.checkGoodsMessage", msg);
        }
        RsGoodsMessage oldRsGoodsMessage = this.getGoodsMessageModelById(rsGoodsMessageDomain.getGoodsMessageId());
        if (null == oldRsGoodsMessage) {
            throw new ApiException("rs.RsGoodsMessageServiceImpl.updateGoodsMessage.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsMessage rsGoodsMessage = this.makeGoodsMessage(rsGoodsMessageDomain, oldRsGoodsMessage);
        this.setGoodsMessageUpdataDefault(rsGoodsMessage);
        this.updateGoodsMessageModel(rsGoodsMessage);
    }

    @Override
    public RsGoodsMessage getGoodsMessage(Integer goodsMessageId) {
        if (null == goodsMessageId) {
            return null;
        }
        return this.getGoodsMessageModelById(goodsMessageId);
    }

    @Override
    public void deleteGoodsMessage(Integer goodsMessageId) throws ApiException {
        if (null == goodsMessageId) {
            return;
        }
        this.deleteGoodsMessageModel(goodsMessageId);
    }

    @Override
    public QueryResult<RsGoodsMessage> queryGoodsMessagePage(Map<String, Object> map) {
        List<RsGoodsMessage> rsGoodsMessageList = this.queryGoodsMessageModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsMessage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsMessageList);
        return queryResult;
    }

    @Override
    public RsGoodsMessage getGoodsMessageByCode(String tenantCode, String goodsMessageCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsMessageCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsMessageCode", goodsMessageCode);
        return this.getGoodsMessageModelByCode(map);
    }

    @Override
    public void deleteGoodsMessageByCode(String tenantCode, String goodsMessageCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsMessageCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsMessageCode", goodsMessageCode);
        this.delGoodsMessageModelByCode(map);
    }
}

