/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsUnitMapper;
import com.yqbsoft.laser.service.resources.domain.RsUnitDomain;
import com.yqbsoft.laser.service.resources.domain.RsUnitReDomain;
import com.yqbsoft.laser.service.resources.model.RsUnit;
import com.yqbsoft.laser.service.resources.service.RsUnitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsUnitServiceImpl
extends BaseServiceImpl
implements RsUnitService {
    private static final String SYS_CODE = "rs.RsUnitServiceImpl";
    private RsUnitMapper rsUnitMapper;

    public void setRsUnitMapper(RsUnitMapper rsUnitMapper) {
        this.rsUnitMapper = rsUnitMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsUnitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUnit(RsUnitDomain rsUnitDomain) {
        if (null == rsUnitDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsUnitDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUnitDefault(RsUnit rsUnit) {
        if (null == rsUnit) {
            return;
        }
        if (null == rsUnit.getDataState()) {
            rsUnit.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsUnit.getGmtCreate()) {
            rsUnit.setGmtCreate(date);
        }
        rsUnit.setGmtModified(date);
        if (StringUtils.isBlank((String)rsUnit.getUnitCode())) {
            rsUnit.setUnitCode(this.getNo(null, "RsUnit", "rsUnit", rsUnit.getTenantCode()));
        }
    }

    private int getUnitMaxCode() {
        int code = 0;
        try {
            return this.rsUnitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.getUnitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUnitUpdataDefault(RsUnit rsUnit) {
        if (null == rsUnit) {
            return;
        }
        rsUnit.setGmtModified(this.getSysDate());
    }

    private void saveUnitModel(RsUnit rsUnit) throws ApiException {
        if (null == rsUnit) {
            return;
        }
        try {
            this.rsUnitMapper.insert(rsUnit);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.saveUnitModel.ex", (Throwable)e);
        }
    }

    private void saveUnitBatchModel(List<RsUnit> rsUnitList) throws ApiException {
        if (null == rsUnitList || rsUnitList.isEmpty()) {
            return;
        }
        try {
            this.rsUnitMapper.insertBatch(rsUnitList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.saveUnitBatchModel.ex", (Throwable)e);
        }
    }

    private RsUnit getUnitModelById(Integer unitId) {
        if (null == unitId) {
            return null;
        }
        try {
            return this.rsUnitMapper.selectByPrimaryKey(unitId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.getUnitModelById", (Throwable)e);
            return null;
        }
    }

    private RsUnit getUnitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsUnitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.getUnitModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUnitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsUnitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.delUnitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsUnitServiceImpl.delUnitModelByCode.num");
        }
    }

    private void deleteUnitModel(Integer unit) throws ApiException {
        if (null == unit) {
            return;
        }
        int i = 0;
        try {
            i = this.rsUnitMapper.deleteByPrimaryKey(unit);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.deleteUnitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsUnitServiceImpl.deleteUnitModel.num");
        }
    }

    private void updateUnitModel(RsUnit rsUnit) throws ApiException {
        if (null == rsUnit) {
            return;
        }
        int i = 0;
        try {
            i = this.rsUnitMapper.updateByPrimaryKey(rsUnit);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.updateUnitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsUnitServiceImpl.updateUnitModel.num");
        }
    }

    private void updateStateUnitModel(Integer unit, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == unit || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unit", unit);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsUnitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.updateStateUnitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsUnitServiceImpl.updateStateUnitModel.null");
        }
    }

    private void updateStateUnitModelByCode(String tenantCode, String unitCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)unitCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("unitCode", unitCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsUnitMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUnitServiceImpl.updateStateUnitModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsUnitServiceImpl.updateStateUnitModelByCode.null");
        }
    }

    private RsUnit makeUnit(RsUnitDomain rsUnitDomain, RsUnit rsUnit) {
        if (null == rsUnitDomain) {
            return null;
        }
        if (null == rsUnit) {
            rsUnit = new RsUnit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsUnit, (Object)rsUnitDomain);
            return rsUnit;
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.makeUnit", (Throwable)e);
            return null;
        }
    }

    private RsUnitReDomain makeRsUnitReDomain(RsUnit rsUnit) {
        if (null == rsUnit) {
            return null;
        }
        RsUnitReDomain rsUnitReDomain = new RsUnitReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsUnitReDomain, (Object)rsUnit);
            return rsUnitReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.makeRsUnitReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsUnit> queryUnitModelPage(Map<String, Object> parammap) {
        try {
            return this.rsUnitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.queryUnitModel", (Throwable)e);
            return null;
        }
    }

    private int countUnit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsUnitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUnitServiceImpl.countUnit", (Throwable)e);
        }
        return i;
    }

    private RsUnit createRsUnit(RsUnitDomain rsUnitDomain) {
        String msg = this.checkUnit(rsUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsUnitServiceImpl.saveUnit.checkUnit", msg);
        }
        RsUnit rsUnit = this.makeUnit(rsUnitDomain, null);
        this.setUnitDefault(rsUnit);
        return rsUnit;
    }

    @Override
    public String saveUnit(RsUnitDomain rsUnitDomain) throws ApiException {
        RsUnit rsUnit = this.createRsUnit(rsUnitDomain);
        this.saveUnitModel(rsUnit);
        return rsUnit.getUnitCode();
    }

    @Override
    public String saveUnitBatch(List<RsUnitDomain> rsUnitDomainList) throws ApiException {
        if (null == rsUnitDomainList || rsUnitDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsUnit> rsUnitList = new ArrayList<RsUnit>();
        String code = "";
        for (RsUnitDomain rsUnitDomain : rsUnitDomainList) {
            RsUnit rsUnit = this.createRsUnit(rsUnitDomain);
            code = rsUnit.getUnitCode();
            rsUnitList.add(rsUnit);
        }
        this.saveUnitBatchModel(rsUnitList);
        return code;
    }

    @Override
    public void updateUnitState(Integer unit, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateUnitModel(unit, dataState, oldDataState, map);
    }

    @Override
    public void updateUnitStateByCode(String tenantCode, String unitCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateUnitModelByCode(tenantCode, unitCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUnit(RsUnitDomain rsUnitDomain) throws ApiException {
        String msg = this.checkUnit(rsUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsUnitServiceImpl.updateUnit.checkUnit", msg);
        }
        RsUnit oldRsUnit = this.getUnitModelById(rsUnitDomain.getUnitId());
        if (null == oldRsUnit) {
            throw new ApiException("rs.RsUnitServiceImpl.updateUnit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsUnit rsUnit = this.makeUnit(rsUnitDomain, oldRsUnit);
        this.setUnitUpdataDefault(rsUnit);
        this.updateUnitModel(rsUnit);
    }

    @Override
    public RsUnit getUnit(Integer unitId) {
        return this.getUnitModelById(unitId);
    }

    @Override
    public void deleteUnit(Integer unitId) throws ApiException {
        this.deleteUnitModel(unitId);
    }

    @Override
    public QueryResult<RsUnit> queryUnitPage(Map<String, Object> map) {
        List<RsUnit> rsUnitList = this.queryUnitModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUnit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsUnitList);
        return queryResult;
    }

    @Override
    public RsUnit getUnitByCode(String tenantCode, String unitCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("unitCode", unitCode);
        return this.getUnitModelByCode(map);
    }

    @Override
    public void deleteUnitByCode(String tenantCode, String unitCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("unitCode", unitCode);
        this.delUnitModelByCode(map);
    }
}

