/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsRtagMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRtagDomain;
import com.yqbsoft.laser.service.resources.domain.RsRtagDomain;
import com.yqbsoft.laser.service.resources.domain.RsRtagReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsRtag;
import com.yqbsoft.laser.service.resources.model.RsRtag;
import com.yqbsoft.laser.service.resources.service.RsGoodsRtagService;
import com.yqbsoft.laser.service.resources.service.RsRtagService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsRtagServiceImpl
extends BaseServiceImpl
implements RsRtagService {
    private static final String SYS_CODE = "rs.RsRtagServiceImpl";
    private RsRtagMapper rsRtagMapper;
    private RsGoodsRtagService rsGoodsRtagService;

    public RsGoodsRtagService getRsGoodsRtagService() {
        return this.rsGoodsRtagService;
    }

    public void setRsGoodsRtagService(RsGoodsRtagService rsGoodsRtagService) {
        this.rsGoodsRtagService = rsGoodsRtagService;
    }

    public void setRsRtagMapper(RsRtagMapper rsRtagMapper) {
        this.rsRtagMapper = rsRtagMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsRtagMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRtag(RsRtagDomain rsRtagDomain) {
        if (null == rsRtagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsRtagDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRtagDefault(RsRtag rsRtag) {
        if (null == rsRtag) {
            return;
        }
        if (null == rsRtag.getDataState()) {
            rsRtag.setDataState(0);
        }
        if (null == rsRtag.getGmtCreate()) {
            rsRtag.setGmtCreate(this.getSysDate());
        }
        rsRtag.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsRtag.getRtagCode())) {
            rsRtag.setRtagCode(this.getNo(null, "RsRtag", "rsRtag", rsRtag.getTenantCode()));
        }
    }

    private int getRtagMaxCode() {
        int code = 0;
        try {
            return this.rsRtagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.getRtagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRtagUpdataDefault(RsRtag rsRtag) {
        if (null == rsRtag) {
            return;
        }
        rsRtag.setGmtModified(this.getSysDate());
    }

    private void saveRtagModel(RsRtag rsRtag) throws ApiException {
        if (null == rsRtag) {
            return;
        }
        try {
            this.rsRtagMapper.insert(rsRtag);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.saveRtagModel.ex", (Throwable)e);
        }
    }

    private void saveRtagBatchModel(List<RsRtag> rsRtagList) throws ApiException {
        if (null == rsRtagList || rsRtagList.isEmpty()) {
            return;
        }
        try {
            this.rsRtagMapper.insertBatch(rsRtagList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.saveRtagBatchModel.ex", (Throwable)e);
        }
    }

    private RsRtag getRtagModelById(Integer rtagId) {
        if (null == rtagId) {
            return null;
        }
        try {
            return this.rsRtagMapper.selectByPrimaryKey(rtagId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.getRtagModelById", (Throwable)e);
            return null;
        }
    }

    private RsRtag getRtagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsRtagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.getRtagModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRtagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsRtagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.delRtagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsRtagServiceImpl.delRtagModelByCode.num");
        }
    }

    private void deleteRtagModel(Integer rtagId) throws ApiException {
        if (null == rtagId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsRtagMapper.deleteByPrimaryKey(rtagId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.deleteRtagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsRtagServiceImpl.deleteRtagModel.num");
        }
    }

    private void updateRtagModel(RsRtag rsRtag) throws ApiException {
        if (null == rsRtag) {
            return;
        }
        int i = 0;
        try {
            i = this.rsRtagMapper.updateByPrimaryKey(rsRtag);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.updateRtagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsRtagServiceImpl.updateRtagModel.num");
        }
    }

    private void updateStateRtagModel(Integer rtagId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rtagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rtagId", rtagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsRtagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.updateStateRtagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsRtagServiceImpl.updateStateRtagModel.null");
        }
    }

    private void updateStateRtagModelByCode(String tenantCode, String rtagCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rtagCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rtagCode", rtagCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsRtagMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsRtagServiceImpl.updateStateRtagModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsRtagServiceImpl.updateStateRtagModelByCode.null");
        }
    }

    private RsRtag makeRtag(RsRtagDomain rsRtagDomain, RsRtag rsRtag) {
        if (null == rsRtagDomain) {
            return null;
        }
        if (null == rsRtag) {
            rsRtag = new RsRtag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsRtag, (Object)rsRtagDomain);
            return rsRtag;
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.makeRtag", (Throwable)e);
            return null;
        }
    }

    private RsRtagReDomain makeRsRtagReDomain(RsRtag rsRtag) {
        if (null == rsRtag) {
            return null;
        }
        RsRtagReDomain rsRtagReDomain = new RsRtagReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsRtagReDomain, (Object)rsRtag);
            return rsRtagReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.makeRsRtagReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsRtag> queryRtagModelPage(Map<String, Object> parammap) {
        try {
            return this.rsRtagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.queryRtagModel", (Throwable)e);
            return null;
        }
    }

    private List<RsRtag> queryRtagModelPageByGoods(Map<String, Object> parammap) {
        try {
            return this.rsRtagMapper.queryRtag(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.queryRtagModel", (Throwable)e);
            return null;
        }
    }

    private int countRtag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsRtagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.countRtag", (Throwable)e);
        }
        return i;
    }

    private int countRtagByGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsRtagMapper.countRtag(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsRtagServiceImpl.countRtag", (Throwable)e);
        }
        return i;
    }

    private RsRtag createRsRtag(RsRtagDomain rsRtagDomain) {
        String msg = this.checkRtag(rsRtagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsRtagServiceImpl.saveRtag.checkRtag", msg);
        }
        RsRtag rsRtag = this.makeRtag(rsRtagDomain, null);
        this.setRtagDefault(rsRtag);
        return rsRtag;
    }

    @Override
    public String saveRtag(RsRtagDomain rsRtagDomain) throws ApiException {
        RsRtag rsRtag = this.createRsRtag(rsRtagDomain);
        this.saveRtagModel(rsRtag);
        for (RsGoodsRtagDomain rsGoodsRtagDomain : rsRtagDomain.getRsGoodsRtagDomainList()) {
            rsGoodsRtagDomain.setRtagCode(rsRtag.getRtagCode());
            rsGoodsRtagDomain.setTenantCode(rsRtag.getTenantCode());
            this.rsGoodsRtagService.saveGoodsRtag(rsGoodsRtagDomain);
        }
        return rsRtag.getRtagCode();
    }

    @Override
    public String saveRtagBatch(List<RsRtagDomain> rsRtagDomainList) throws ApiException {
        if (null == rsRtagDomainList || rsRtagDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsRtag> rsRtagList = new ArrayList<RsRtag>();
        String code = "";
        for (RsRtagDomain rsRtagDomain : rsRtagDomainList) {
            RsRtag rsRtag = this.createRsRtag(rsRtagDomain);
            code = rsRtag.getRtagCode();
            rsRtagList.add(rsRtag);
        }
        this.saveRtagBatchModel(rsRtagList);
        return code;
    }

    @Override
    public void updateRtagState(Integer rtagId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateRtagModel(rtagId, dataState, oldDataState, map);
    }

    @Override
    public void updateRtagStateByCode(String tenantCode, String rtagCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateRtagModelByCode(tenantCode, rtagCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRtag(RsRtagDomain rsRtagDomain) throws ApiException {
        String msg = this.checkRtag(rsRtagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsRtagServiceImpl.updateRtag.checkRtag", msg);
        }
        RsRtag oldRsRtag = this.getRtagModelById(rsRtagDomain.getRtagId());
        if (null == oldRsRtag) {
            throw new ApiException("rs.RsRtagServiceImpl.updateRtag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (1 == oldRsRtag.getDataState()) {
            oldRsRtag.setStartTime(rsRtagDomain.getStartTime());
            oldRsRtag.setEndTime(rsRtagDomain.getEndTime());
            this.updateRtagModel(oldRsRtag);
        } else {
            RsRtag rsRtag = this.makeRtag(rsRtagDomain, oldRsRtag);
            rsRtag.setDataState(0);
            this.setRtagUpdataDefault(rsRtag);
            this.updateRtagModel(rsRtag);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", rsRtagDomain.getTenantCode());
            map.put("rtagCode", rsRtagDomain.getRtagCode());
            QueryResult<RsGoodsRtag> rsGoodsRtagQueryResult = this.rsGoodsRtagService.queryGoodsRtagPage(map);
            for (RsGoodsRtag rsGoodsRtag : rsGoodsRtagQueryResult.getList()) {
                this.rsGoodsRtagService.deleteGoodsRtag(rsGoodsRtag.getGoodsRtagId());
            }
            for (RsGoodsRtagDomain rsGoodsRtagDomain : rsRtagDomain.getRsGoodsRtagDomainList()) {
                rsGoodsRtagDomain.setRtagCode(rsRtag.getRtagCode());
                rsGoodsRtagDomain.setTenantCode(rsRtag.getTenantCode());
                this.rsGoodsRtagService.saveGoodsRtag(rsGoodsRtagDomain);
            }
        }
    }

    @Override
    public RsRtag getRtag(Integer rtagId) {
        return this.getRtagModelById(rtagId);
    }

    @Override
    public void deleteRtag(Integer rtagId) throws ApiException {
        this.deleteRtagModel(rtagId);
    }

    @Override
    public QueryResult<RsRtag> queryRtagPage(Map<String, Object> map) {
        List<RsRtag> rsRtagList = this.queryRtagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRtag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsRtagList);
        return queryResult;
    }

    @Override
    public QueryResult<RsRtag> queryRtagPageByGoods(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        int i = this.countRtagByGoods(map);
        if (i > 0) {
            List<RsRtag> rsRtagList = this.queryRtagModelPageByGoods(map);
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(this.countRtagByGoods(map));
            queryResult.setPageTools((SupPageTools)pageTools);
            queryResult.setList(rsRtagList);
        }
        return queryResult;
    }

    @Override
    public RsRtag getRtagByCode(String tenantCode, String rtagCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rtagCode", rtagCode);
        return this.getRtagModelByCode(map);
    }

    @Override
    public void deleteRtagByCode(String tenantCode, String rtagCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rtagCode", rtagCode);
        this.delRtagModelByCode(map);
        QueryResult<RsGoodsRtag> rsGoodsRtagQueryResult = this.rsGoodsRtagService.queryGoodsRtagPage(map);
        for (RsGoodsRtag rsGoodsRtag : rsGoodsRtagQueryResult.getList()) {
            this.rsGoodsRtagService.deleteGoodsRtag(rsGoodsRtag.getGoodsRtagId());
        }
    }

    @Override
    public void updateRtagStateJob(String tenantCode) throws ApiException {
        this.start(tenantCode);
        this.end(tenantCode);
    }

    private void start(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tenantCode)) {
            map.put("tenantCode", tenantCode);
        }
        map.put("dataState", 0);
        map.put("startTimeQend", new Date());
        List<RsRtag> rsRtags = this.queryRtagModelPage(map);
        for (RsRtag rsRtag : rsRtags) {
            this.updateRtagState(rsRtag.getRtagId(), 1, rsRtag.getDataState(), null);
        }
    }

    private void end(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tenantCode)) {
            map.put("tenantCode", tenantCode);
        }
        map.put("dataState", 1);
        map.put("endTimeQend", new Date());
        List<RsRtag> rsRtags = this.queryRtagModelPage(map);
        for (RsRtag rsRtag : rsRtags) {
            this.updateRtagState(rsRtag.getRtagId(), -1, rsRtag.getDataState(), null);
        }
    }
}

