/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.channeles.ChannelGoodsBean;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.GoodsBean;
import com.yqbsoft.laser.service.resources.domain.InfInfuencerGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.OcReorderDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandauDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.StockDomain;
import com.yqbsoft.laser.service.resources.enumc.ResourcesStartCon;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.resources.service.RsBrandauService;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsResourceService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RsResourceServiceImpl
extends BaseServiceImpl
implements RsResourceService {
    public static final String SYS_CODE = "rs.RsResourceServiceImpl";
    private RsResourceGoodsService rsResourceGoodsService;
    private RsResourceListService rsResourceListService;
    private RsSenddataBaseService rsSenddataBaseService;
    private RsGoodsClassService rsGoodsClassService;
    private RsBrandService rsBrandService;
    private RsBrandauService rsBrandauService;
    private RsClasstreeService rsClasstreeService;

    public void setRsGoodsClassService(RsGoodsClassService rsGoodsClassService) {
        this.rsGoodsClassService = rsGoodsClassService;
    }

    public RsClasstreeService getRsClasstreeService() {
        if (null == this.rsClasstreeService) {
            this.rsClasstreeService = (RsClasstreeService)ApplicationContextUtil.getService((String)"rsClasstreeService");
        }
        if (null == this.rsClasstreeService) {
            this.logger.error("rs.RsResourceServiceImpl.getRsClasstreeService.null");
        }
        return this.rsClasstreeService;
    }

    public RsBrandService getRsBrandService() {
        if (null == this.rsBrandService) {
            this.rsBrandService = (RsBrandService)ApplicationContextUtil.getService((String)"rsBrandService");
        }
        return this.rsBrandService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        return this.rsResourceGoodsService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    public RsBrandauService getRsBrandauService() {
        return this.rsBrandauService;
    }

    public void setRsBrandauService(RsBrandauService rsBrandauService) {
        this.rsBrandauService = rsBrandauService;
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), true);
    }

    private OcReorderDomain sendSaveResources(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.start", (Object)JsonUtil.buildNormalBinder().toJson(resourceGoodsList));
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        this.updateLiveGoodsStock(resourceGoodsList, type);
        if ("3".equals(type)) {
            for (ResourceStockDomain resourceStockDomain : resourceGoodsList) {
                resourceStockDomain.setGoodsNum(resourceStockDomain.getRefundGoodsNum());
            }
        }
        try {
            List<RsSenddata> rsSenddataList = channelflag ? this.rsResourceGoodsService.updateResourceChannleStock(resourceGoodsList, type) : this.rsResourceGoodsService.updateResourceStock(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return ocReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.error", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    private synchronized void updateLiveGoodsStock(List<ResourceStockDomain> resourceGoodsList, String type) {
        this.logger.error("rs.RsResourceServiceImpl.resourceGoodsList====>", (Object)JsonUtil.buildNormalBinder().toJson(resourceGoodsList));
        HashMap<String, Object> infParam = new HashMap<String, Object>();
        for (ResourceStockDomain resourceStockDomain : resourceGoodsList) {
            if (!"63".equals(resourceStockDomain.getGoodsType())) continue;
            infParam.put("infuencerGoodsValue1", resourceStockDomain.getSkuCode());
            infParam.put("infuencerGoodsType", resourceStockDomain.getGoodsType());
            infParam.put("tenantCode", resourceStockDomain.getTenantCode());
            QueryResult<InfInfuencerGoodsReDomain> queryInfuencerGoodsPage = this.queryInfuencerGoodsPage(infParam);
            if (queryInfuencerGoodsPage == null || ListUtil.isEmpty((Collection)queryInfuencerGoodsPage.getList()) || queryInfuencerGoodsPage.getList().size() == 0) {
                this.logger.error("rs.RsResourceServiceImpl.updateLiveGoodsStock.queryInfuencerGoodsPage.is null", (Object)JsonUtil.buildNormalBinder().toJson(infParam));
                throw new ApiException("\u76f4\u64ad\u5e93\u5b58\u6263\u51cf\u5931\u8d25");
            }
            InfInfuencerGoodsReDomain goodsReDomain = (InfInfuencerGoodsReDomain)queryInfuencerGoodsPage.getList().get(0);
            if ("1".equals(type)) {
                this.updateInfuencerGoodsState(goodsReDomain.getInfuencerGoodsId(), goodsReDomain.getDataState(), goodsReDomain.getDataState(), null);
                goodsReDomain.setInfuencerGoodsNum(goodsReDomain.getInfuencerGoodsNum().subtract(resourceStockDomain.getGoodsNum()));
                this.updateInfuencerGoods(goodsReDomain);
                continue;
            }
            if (!"3".equals(type) && !"4".equals(type)) continue;
            this.updateInfuencerGoodsState(goodsReDomain.getInfuencerGoodsId(), goodsReDomain.getDataState(), goodsReDomain.getDataState(), null);
            goodsReDomain.setInfuencerGoodsNum(goodsReDomain.getInfuencerGoodsNum().add(resourceStockDomain.getRefundGoodsNum()));
            this.updateInfuencerGoods(goodsReDomain);
        }
    }

    public String updateInfuencerGoods(InfInfuencerGoodsReDomain goodsReDomain) {
        String apiCode = "inf.infuencer.updateInfuencerGoods";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("infInfuencerGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)goodsReDomain));
        return this.internalInvoke(apiCode, pmap);
    }

    public String updateInfuencerGoodsState(Integer infuencerGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        String apiCode = "inf.infuencer.updateInfuencerGoodsState";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("infuencerGoodsId", String.valueOf(infuencerGoodsId));
        pmap.put("dataState", String.valueOf(dataState));
        pmap.put("oldDataState", String.valueOf(oldDataState));
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.internalInvoke(apiCode, pmap);
    }

    public QueryResult<InfInfuencerGoodsReDomain> queryInfuencerGoodsPage(Map<String, Object> map) {
        String apiCode = "inf.infuencer.queryInfuencerGoodsPage";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, pmap, InfInfuencerGoodsReDomain.class);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), true);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByPayBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), true);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByPayBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), true);
    }

    @Override
    public String sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveResourceGoods(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsResourceGoodsDomain.getGoodsCode();
    }

    @Override
    public void sendSavePassResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSavePassResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoods(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsResourceGoodsDomain.getGoodsCode();
    }

    @Override
    public void sendSaveResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.rsResourceGoodsService.updateResourceGoods(rsResourceGoodsDomain);
    }

    @Override
    public void sendDelResourceGoodsByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.delResourceGoodsByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveGoods(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveGoods(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveGoodsNotDataState(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveGoodsNotDataState(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutGoods(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoods(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateCanlAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditCanlResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourcePass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourcePass(goodsIds);
        this.logger.error("rs.RsResourceServiceImpl.sendUpdateAuditResourcePass.rsSenddataList", (Object)JsonUtil.buildNormalBinder().toJson(rsSenddataList));
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourceNoPass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourceNoPass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateByIdForMemo(Integer goodsId, Integer dataState, Integer oldDataState, Map<String, Object> paramMap) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateByIdForMemo(goodsId, dataState, oldDataState, paramMap);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateById(Integer goodsId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateById(goodsId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuStateById(Integer skuId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuStateById(skuId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsById(Integer goodsId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteGoodsById(goodsId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteResourceGoodsList(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteResourceGoodsList(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void deleteVipvopGoodsJob(String tenantCode, Integer num) {
        if (num == null) {
            num = 14;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsType", "41");
        map.put("goodsOldcode", "-1");
        map.put("goodsOrigin", "2");
        map.put("dataOpbillstate", 0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -num.intValue());
        calendar.add(12, -10);
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDate = sdf.format(calendar.getTime());
        map.put("delistingTimeQend", formatDate);
        this.logger.error("rs.RsResourceServiceImpl.deleteVipvopGoodsJob.param", (Object)JsonUtil.buildNormalBinder().toJson(map));
        QueryResult<RsResourceGoodsReDomain> goodsPage = this.rsResourceGoodsService.queryResourceGoodsPage(map);
        if (goodsPage == null || ListUtil.isEmpty((Collection)goodsPage.getList())) {
            return;
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (RsResourceGoodsReDomain domain : goodsPage.getList()) {
            goodsIds.add(domain.getGoodsId());
        }
        this.sendDeleteResourceGoodsList(goodsIds);
    }

    @Override
    public void sendUpdateSoldOutSku(Integer skuId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutSku(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveSku(Integer skuId) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveSku(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuEdit(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateBatchSkuEdit(List<EditSkuDomain> editSkuDomainList) throws ApiException {
        if (ListUtil.isEmpty(editSkuDomainList)) {
            return null;
        }
        String msg = "";
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuBatchEdit(editSkuDomainList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return msg;
    }

    @Override
    public void sendUpdateSkuEditErp(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuErpEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuChannel(String goodsCode, String skuCode, String skuOldcode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuChannel(goodsCode, skuCode, skuOldcode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public List<RsSenddata> sendSaveDisResourceGoods(List<DisRsResourceGoodsDomain> disRsResourceGoodsList) throws ApiException {
        return this.rsResourceGoodsService.saveDisResourceGoods(disRsResourceGoodsList);
    }

    @Override
    public List<RsSenddata> sendSaveDisSku(List<DisRsSkuDomain> disRsSkuList) throws ApiException {
        this.logger.error("rs.RsResourceServiceImpl.sendSaveDisSku11");
        return this.rsResourceGoodsService.saveDisSku(disRsSkuList);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        return this.rsResourceGoodsService.updateDisCannelSku(skuOldcode, channelCode, tenantCode);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        return this.rsResourceGoodsService.updateDisCannelGoods(goodsOldcode, channelCode, tenantCode);
    }

    @Override
    public List<RsSenddata> sendDeleteDisSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        return this.rsResourceGoodsService.deleteDisSku(skuOldcode, channelCode, tenantCode);
    }

    @Override
    public List<RsSenddata> sendDeleteDisGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        return this.rsResourceGoodsService.deleteDisGoods(goodsOldcode, channelCode, tenantCode);
    }

    @Override
    public List<RsSenddata> sendSaveDisSkuEdit(List<DisRsSkuDomain> disRsSkuList) {
        return this.rsResourceGoodsService.saveDisSkuEdit(disRsSkuList);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelGoodsState(Map<String, Object> map) {
        return this.rsResourceGoodsService.updateDisCannelGoodsState(map);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelSkuState(Map<String, Object> map) {
        return this.rsResourceGoodsService.updateDisCannelSkuState(map);
    }

    @Override
    public void sendDeleteSkuBySkuId(Integer skuId) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteSkuBySkuId(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateChannelGoods(String channelCode, String tenantCode) {
        this.rsResourceGoodsService.updateChannelGoods(channelCode, tenantCode);
        return "success";
    }

    @Override
    public String sendUpdateChannelQuwey(Map<String, Object> map) {
        if (MapUtil.isNotEmpty(map) && null != map.get("skuNo") && StringUtils.isNotBlank((String)String.valueOf(map.get("skuNo")))) {
            this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        } else {
            this.rsResourceGoodsService.updateChannelQuwey(map);
        }
        return "";
    }

    @Override
    public String sendUpdateChannelSkuQuwey(Map<String, Object> map) {
        this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        return "";
    }

    @Override
    public void sendSaveChannelGoods(ChannelGoodsBean channelGoodsBean) {
        if (null == channelGoodsBean) {
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveChannelGoods(channelGoodsBean);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public void sendDelChannelGoods(ChannelGoodsBean channelGoodsBean) {
        if (null == channelGoodsBean) {
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteChannelGoods(channelGoodsBean);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateSkuNum(String skuNo, BigDecimal goodsNum, BigDecimal goodsWeight, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNum(skuNo, goodsNum, goodsWeight, memberCode, memberCcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String beforeSendUpdateSkuNum(String skuNo, String goodsNum, String goodsWeight, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        BigDecimal bigDecimalNum = new BigDecimal(goodsNum);
        BigDecimal bigDecimalWeight = new BigDecimal(goodsWeight);
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNum(skuNo, bigDecimalNum, bigDecimalWeight, memberCode, memberCcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String sendUpdateSkuLockNum(StockDomain stockDomain) {
        return this.rsResourceGoodsService.updateSkuLockNum(stockDomain);
    }

    @Override
    public String sendSaveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.saveGoodsClass(rsGoodsClassDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return rsSenddataList.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public void sendUpdateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateGoodsClass(rsGoodsClassDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsClass(Integer goodsClassId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.deleteGoodsClass(goodsClassId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDelGoodsClassByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.delGoodsClassByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveGoodsClassInit(String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.saveGoodsClassInit(tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateGoodsClassChannelInit(String tenantCode) {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateGoodsClassChannelInit(tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
        return "";
    }

    @Override
    public void sendUpdateGoodsEocode(String goodsCode, String goodsEocode, String tenantCode) throws ApiException {
        this.rsResourceGoodsService.updateGoodsEocode(goodsCode, goodsEocode, tenantCode);
    }

    @Override
    public void sendUpdateSkuEocode(String skuCode, String skuEocode, String tenantCode) throws ApiException {
        this.rsResourceGoodsService.updateSkuEocode(skuCode, skuEocode, tenantCode);
    }

    @Override
    public void sendUpdateShelveBatchSku(List<Integer> skuIdList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveBatchSku(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutBatchSku(List<Integer> skuIdList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutBatchSku(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteBatchSkuBySkuId(List<Integer> skuIdList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteBatchSkuBySkuId(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSaveBrand(RsBrandDomain rsBrandDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().saveBrand(rsBrandDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsBrandDomain.getBrandCode();
    }

    @Override
    public void sendUpdateBrand(RsBrandDomain rsBrandDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().updateBrand(rsBrandDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateBrandau(RsBrandauDomain rsBrandauDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandauService().sendUpdateBrandau(rsBrandauDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteBrand(Integer brandId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().deleteBrand(brandId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSaveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList;
        if (null == rsClasstreeDomain) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveClasstree.null");
            return "";
        }
        RsClasstree rsClasstree = null;
        rsClasstree = "5".equals(rsClasstreeDomain.getClasstreeType()) ? this.getRsClasstreeService().getClasstreeByCode(this.getQueryMapParam("classtreeCode,tenantCode", new Object[]{rsClasstreeDomain.getClasstreeCode(), rsClasstreeDomain.getTenantCode()})) : this.getRsClasstreeService().checkClasstreeName(rsClasstreeDomain.getClasstreeName(), rsClasstreeDomain.getTenantCode());
        if (null == rsClasstree && ListUtil.isNotEmpty(rsSenddataList = this.getRsClasstreeService().saveClasstree(rsClasstreeDomain))) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsClasstreeDomain.getClasstreeCode();
    }

    @Override
    public String sendSaveClasstreeTow(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsClasstreeService().saveClasstree(rsClasstreeDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsClasstreeDomain.getClasstreeCode();
    }

    @Override
    public void sendUpdateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsClasstreeService().updateClasstree(rsClasstreeDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteClasstree(Integer classtreeId) throws ApiException {
        List<RsSenddata> rsSenddataList;
        if (StringUtils.isBlank((Integer)classtreeId)) {
            this.logger.error("rs.RsResourceServiceImpl.sendDeleteClasstree", (Object)classtreeId);
        }
        if (ListUtil.isNotEmpty(rsSenddataList = this.getRsClasstreeService().deleteClasstree(classtreeId))) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendupdateOrder(List<RsGoodsClassDomain> rsGoodsClassDomains) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomains)) {
            this.logger.error("rs.RsResourceServiceImpl.sendupdateOrder", rsGoodsClassDomains);
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateOrderBatch(rsGoodsClassDomains);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public RsResourceGoodsReDomain getResourceGoodsReDomain(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsResourceServiceImpl.getResourceGoodsReDomain");
            return null;
        }
        String skuNo = (String)map.get("skuNo");
        String goodsType = (String)map.get("goodsType");
        String memberCode = (String)map.get("memberCode");
        String memberCcode = (String)map.get("memberCcode");
        String channelCode = (String)map.get("channelCode");
        String tenantCode = (String)map.get("tenantCode");
        String goodsPro = null == map.get("goodsPro") ? null : (String)map.get("goodsPro");
        boolean flag = false;
        if (StringUtils.isBlank((String)goodsType) && StringUtils.isNotBlank((String)goodsPro) && "6".equals(goodsPro)) {
            goodsType = "06,28";
        } else if (StringUtils.isBlank((String)goodsType) || goodsType.equals("00")) {
            goodsType = "26";
            flag = true;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuNo, memberCode, memberCcode, channelCode, goodsType, tenantCode);
        if (null == goodsBean && flag) {
            goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuNo, memberCode, memberCcode, channelCode, "00", tenantCode);
        }
        if (null == goodsBean) {
            this.logger.error("rs.RsResourceServiceImpl.getResourceBySkuNoType.", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.makeReDomain(goodsBean.getRsResourceGoods(), false);
        return rsResourceGoodsReDomain;
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByOrderStr(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResourcesStr(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    private OcReorderDomain sendSaveResourcesStr(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        try {
            List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateResourceStockStr(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return ocReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.error", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByBackStr(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResourcesStr(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public void sendDeleteSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendDeleteSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        skuIdList.add(goodsBean.getRsSku().getSkuId());
        this.sendDeleteBatchSkuBySkuId(skuIdList);
    }

    @Override
    public void sendUpdateShelveSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        this.sendUpdateShelveSku(goodsBean.getRsSku().getSkuId());
    }

    @Override
    public void sendUpdateSoldOutSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        skuIdList.add(goodsBean.getRsSku().getSkuId());
        this.sendUpdateSoldOutBatchSku(skuIdList);
    }

    @Override
    public void updateBrandauState(Integer brandauId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        List<RsSenddata> list = this.rsBrandauService.updateBrandauState(brandauId, dataState, oldDataState, memo);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendOpData(list);
        }
    }

    @Override
    public void updateBrandauStateByCode(String tenantCode, String brandauCode, Integer dataState, Integer oldDataState) throws ApiException {
        List<RsSenddata> list = this.rsBrandauService.updateBrandauStateByCode(tenantCode, brandauCode, dataState, oldDataState);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendOpData(list);
        }
    }

    @Override
    public OcReorderDomain updateResourceStockByContract(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        ResourceStockDomain resourceStockDomain;
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            this.logger.error("rs.RsResourceServiceImpl.updateResourceStockByContract", (Object)"resourceGoodsList isnull");
            return ocReorderDomain;
        }
        String type = null;
        Iterator<ResourceStockDomain> i$ = resourceGoodsList.iterator();
        while (i$.hasNext() && !StringUtils.isNotBlank((String)(type = (resourceStockDomain = i$.next()).getType()))) {
        }
        if (StringUtils.isBlank(type)) {
            ocReorderDomain.setOrderState("3");
            this.logger.error("rs.RsResourceServiceImpl.updateResourceStockByContract.type", (Object)"type isnull");
            return ocReorderDomain;
        }
        return this.sendSaveResources(resourceGoodsList, type, true);
    }

    @Override
    public OcReorderDomain updateResourceStockByContractBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        ResourceStockDomain resourceStockDomain;
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            this.logger.error("rs.RsResourceServiceImpl.updateResourceStockByContractBack", (Object)"resourceGoodsList isnull");
            return ocReorderDomain;
        }
        String type = null;
        Iterator<ResourceStockDomain> i$ = resourceGoodsList.iterator();
        while (i$.hasNext() && !StringUtils.isNotBlank((String)(type = (resourceStockDomain = i$.next()).getType()))) {
        }
        if (StringUtils.isBlank(type)) {
            ocReorderDomain.setOrderState("3");
            this.logger.error("rs.RsResourceServiceImpl.updateResourceStockByContractBack.type", (Object)"type isnull");
            return ocReorderDomain;
        }
        return this.sendSaveResourcesStr(resourceGoodsList, type, false);
    }

    @Override
    public void sendUpdateAuditDisCostPriceResourcePass(List<Integer> goodsIds, List<String> skuCodes) {
        this.logger.error("rs.RsResourceServiceImpl.sendUpdateAuditDisCostPriceResourcePas.goodsIds", (Object)JsonUtil.buildNormalBinder().toJson(goodsIds));
        this.logger.error("rs.RsResourceServiceImpl.sendUpdateAuditDisCostPriceResourcePas.skuCodes", (Object)JsonUtil.buildNormalBinder().toJson(skuCodes));
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourcePass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            for (RsSenddata rsSenddata : rsSenddataList) {
                rsSenddata.setSkuCodes(skuCodes);
            }
            this.logger.error("rs.RsResourceServiceImpl.sendUpdateAuditDisCostPriceResourcePas.rsSenddataList", (Object)JsonUtil.buildNormalBinder().toJson(rsSenddataList));
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }
}

